% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskGlobals.R
\name{setTaskStructure}
\alias{setTaskStructure}
\title{Set task repository directory structure.}
\usage{
setTaskStructure(pathgen)
}
\arguments{
\item{pathgen}{optional function returning a list of paths, currently \code{\link{pathsGLPG}} or \code{\link{pathsPMS}}.}
}
\value{
The task directory structure function invisibly.
}
\description{
Set task repository directory structure.
}
\examples{
fun <- function(project,package,taskname,sponsor) {
  basePath <- file.path("\%ROOT\%",sponsor,project,package)
  paths <- list(
    root = "\%ROOT\%",
    datasrc = file.path(basePath, "raw", "data_source"),
    data = file.path(basePath, "output","adhoc",taskname),
    bin  = file.path(basePath, "output","adhoc",taskname,"bin"),
    code = file.path(basePath, "progs"),
    doc  = file.path(basePath, "docs"),
    log  = file.path(basePath, "output","log")
  )
}
setTaskStructure(fun)
}
