\name{PruneNet}
\alias{PruneNet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Evaluates consistency of inferred networks with prior in vitro information
}
\description{
Evaluates consistency of inferred networks with prior in vitro information
}
\usage{
PruneNet(evalNet.o)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{evalNet.o}{
output object from EvalConsNet}
}

\value{
  A list with following entries:

   \item{sign}{gene signature}
   \item{netcons}{Vector summarising properties of network and the consistency with model pathway signature: nG is the number of genes, nE is the number of edges(significant correlations) of relevance network generated by function BuildRN, fE is the ratio of the number of the edges of relevance network to the number of the edges between all the genes in the signatures,
   fconsE is the ratio of the number of nE,which are consistent with the prior information (i.e. sign of the observed correlation equals to the signs predicted by the model) to the number of edges of relevance network, Pval(consist) is a p-value which reflects the significance of fconsE,it is derived from randomisations that yielded an average connectivity larger than the observed one}
   \item{consist.score}{consistency score} 
   \item{pradj}{pruned network}
}
\references{
{Jiao Y, Lawler K, Patel GS, Purushotham A, Jones AF, Grigoriadis A, Ng T, Teschendorff AE. Denoising algorithm based on relevance network topology improves molecular pathway activity inference. Submitted.}

{Teschendorff AE, Gomez S, Arenas A, El-Ashry D, Schmidt M, et al. (2010) Improved prognostic classification of breast
cancer defined by antagonistic activation patterns of immune response pathway modules. BMC Cancer 10:604.}

}
\author{Andrew E Teschendorff, Yan Jiao}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{

## The function is currently defined as
function(evalNet.o){

######################################
adj.m <- evalNet.o$adj;
netsignedge.m <- evalNet.o$netsign;
sign.v <- evalNet.o$s;
netcons<- evalNet.o$netcons
######################################

## first need to define inverse map
ng <- nrow(adj.m);
imap.m <- matrix(nrow=2,ncol=0.5*ng*(ng-1));
ie <- 1;
for(g1 in 1:(ng-1)){
 for(g2 in (g1+1):ng){
  imap.m[,ie] <- c(g1,g2);
  ie <- ie+1;
 }
  }
pruneE.idx <- which(netsignedge.m[1,]!=netsignedge.m[2,]);
pradj.m <- adj.m;
for(e in pruneE.idx){
  rowe <- imap.m[1,e];
  cole <- imap.m[2,e];
  pradj.m[rowe,cole] <- 0;
  pradj.m[cole,rowe] <- 0;
  }
diag(pradj.m)<-0


(sum(pradj.m))/sum(adj.m)->  consist.score

return(list(pradj=pradj.m,sign=sign.v,consist.score=consist.score,netcons=netcons));
  }
  
  library(DARTData)
  data(data.m)
  data(sign.v)
  ### do BuildRN
  BuildRN.o <- BuildRN(data.m,sign.v,fdr=0.05) 
  EvalConsNet.o <- EvalConsNet(BuildRN.o)
  PruneNet.o <- PruneNet(EvalConsNet.o)
  ### Results on consistency of inferred networks with model pathway signature
  print(PruneNet.o$netcons)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
