% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_function.r
\name{compute_pair_to_pair_dists}
\alias{compute_pair_to_pair_dists}
\title{Function to compute pairwise distances and ensure matrix format}
\usage{
compute_pair_to_pair_dists(data, metric = "euclidean")
}
\arguments{
\item{data}{input clustering results}

\item{metric}{metric of the distance, Euclidean by default}
}
\value{
a pairwise distances' matrix
}
\description{
Function to compute pairwise distances and ensure matrix format
}
\examples{

n = 300; noise = 0.05; seed = 1782;
theta <- seq(0, pi, length.out = n / 2)
 x1 <- cos(theta) + rnorm(n / 2, sd = noise)
 y1 <- sin(theta) + rnorm(n / 2, sd = noise)
 x2 <- cos(theta + pi) + rnorm(n / 2, sd = noise)
 y2 <- sin(theta + pi) + rnorm(n / 2, sd = noise)
 X <- rbind(cbind(x1, y1), cbind(x2, y2))

dist_matrix <- compute_pair_to_pair_dists(X)
}
