% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmclustering.R
\name{seq2hmm.ll}
\alias{seq2hmm.ll}
\title{Sequence-to-HMM Likelihood}
\usage{
seq2hmm.ll(hmm)
}
\arguments{
\item{hmm}{An \code{hmm} object (see \code{\link[seqHMM]{build_hmm}})
containing a single sequence.}
}
\value{
The log likelihood of the sequence contained in \code{hmm}, value
  will be set to minus infinity if the sequence contains illegal emissions.
}
\description{
Compute the sequence-to-HMM likelihood of an HMM evaluated for a single
sequence and check if the sequence contains emissions that are not possible
according to the HMM. Auxiliary function used in \code{\link{select.seeds}}
and \code{\link{assign.clusters}}.
}
\seealso{
Used in \code{\link{select.seeds}} and
  \code{\link{assign.clusters}}.
}
