% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockdyn-methods.R
\docType{class}
\name{DeponsBlockdyn-class}
\alias{DeponsBlockdyn-class}
\title{DeponsBlockdyn-class}
\description{
Stores objects containing population size for different parts of
the landscape (i.e. different 'blocks')
}
\details{
The \code{dyn} slot contains a data frame with the columns 'tick',
which indicates the number of half-hourly time steps since the start of the
simulation; a column 'block' indicating the region of the landscape where
animals were counted, a 'count' column with the number of animals in that block
and tick. The 'real.time' column shows the real-world equivalent to 'tick, i.e.
the time that has passed since 'startday'.
}
\section{Slots}{

\describe{
\item{\code{title}}{Character. Name of the object or simulation}

\item{\code{landscape}}{Character. Identifier for the landscape used in the DEPONS
simulations. The landscapes 'DanTysk', 'Gemini', 'Kattegat', 'North Sea',
'Homogeneous', and 'User defined' are distributed with the DEPONS model.}

\item{\code{simtime}}{\code{\link{POSIXlt}} object with the date and time when the simulation was
finished. This is read from the name of the imput file.}

\item{\code{startday}}{POSIXlt object with the first day of the simulation, i.e.
the first day in the period that the simulations are intended to represent in
the real world.}

\item{\code{dyn}}{Data frame with simulation output.}
}}

\note{
DeponsBlockdyn-objects are usually read in from csv files produced during
DEPONS simulations. These files are named 'PorpoisePerBlock.XXX.csv', where XXX
indicates the date and time when the simulation was finished.
}
\examples{
a.DeponsBlockdyn <- new("DeponsBlockdyn")
a.DeponsBlockdyn
}
\seealso{
\code{\link[DEPONS2R]{plot.DeponsBlockdyn}} and
\code{\link[DEPONS2R]{read.DeponsBlockdyn}}.
}
