% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-methods.R
\name{read.DeponsTrack}
\alias{read.DeponsTrack}
\title{Reading DEPONS track files}
\usage{
read.DeponsTrack(
  fname,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  crs = as.character(NA),
  tz = "UTC"
)
}
\arguments{
\item{fname}{Name of the file (character) that contains movement data
generated by DEPONS. The name includes the path to the directory if this is
not the current working directory.}

\item{title}{Optional character string giving name of simulation}

\item{landscape}{Optional character string with the landscape used in the
simulation}

\item{simtime}{Character sting with date of simulation (format yyyy-mm-dd).
If not provided this is obtained from name of input file}

\item{crs}{Character, coordinate reference system (map projection)}

\item{tz}{Time zone used in simulations. Defaults to UTC.
#'}
}
\value{
Returns a \code{DeponsTrack} object with the elements \code{title},
\code{simtime}, \code{crs}, and \code{tracks}. The \code{date} is extracted
from input data if not provided explicitly and stored as a
\code{\link{POSIXlt}} object. The element \code{tracks} is a list of objects
of class \link[sp]{SpatialPointsDataFrame}, each of which corresponds to one
simulated animal (several animals can be tracked in one simulation).
}
\description{
Function  for reading movement tracks produced by DEPONS. These
describe movements of simulated animals within the simulation landscape, where
the positions after each 30-min time step are provided using the coordinate
reference system that were used for generating these landscapes.See
van Beest et al. (2018) and Nabe-Nielsen et al. (2013) for details regarding
how these files were generated as a balance between correlated random walk
behaviour and spatial memory behaviour, which allows animals to return to
previously visited food patches.
}
\examples{
data(porpoisetrack) # Load data for use in example

# Use standard DEPONS coordinate reference system / map projection:
the.crs <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
 +datum=WGS84 +units=m +no_defs"

\dontrun{
one.fname <- "~/Applications/DEPONS/
  RandomPorpoise.2020.Jul.31.09_43_10.csv"

porpoisetrack <- read.DeponsTrack(one.fname, title="Track simulated using DEPONS 2.0",
  crs=the.crs)

}

# Plot the first of the simulated tracks
plot(porpoisetrack)
}
