% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{create_master_res}
\alias{create_master_res}
\title{Create a data set consisting of aggregated data for multiple contrasts.}
\usage{
create_master_res(res_list, filename = "master_DE.txt",
  method = "union", lfc_filter = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets created with DESeq2::results(). I.E: list(res1, res2, ..., resN).}

\item{filename}{Destination output filename.}

\item{method}{Method for aggregating data.  "union" will gather expression data for all samples in results list
when a gene is differentially expressed in at least one sample.  "intersection" will gather expression data only for genes that
are DE in all samples of the result list.}

\item{lfc_filter}{Impose a filter on the DE set by a minimum absolute log2foldChange as determined by init_cutoffs(). Default=FALSE.}
}
\value{
This function returns a data frame containing union-based aggregation of all provided result sets.
Results of this function are also written to file in the /DE/data/ directory in tab-delimited format.
}
\description{
This function creates a master result set for the provided DE result sets.  This function finds the union of
DE gene names and extracts those rows from all DE result sets, then merges the sets into a single
master DE file containing both log2foldChange and padj values.  The results are written to the DE
output directory and returned by the function.
Relies on init_cutoffs() significant thresholds.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Generate the master DE data frame using union-based aggregation
master_df <- create_master_res(res_list=myResList, filename="master_DE.txt",
                               method="union")

#Generate the master DE data frame using intersection-based aggregation.
#Filter genes below minimum log fold-change.
master_df <- create_master_res(res_list=myResList, filename="master_DE.txt",
                               method="union", lfc_filter=TRUE)

}
}
\seealso{
\code{\link{init_cutoffs}}, \code{\link{create_dir_struct}}
}
\keyword{DE}
\keyword{aggregate}
\keyword{filter}
\keyword{master}
\keyword{result}
