% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{histWSAF}
\alias{histWSAF}
\title{WSAF histogram}
\usage{
histWSAF(obsWSAF, exclusive = TRUE, title = "Histogram 0<WSAF<1")
}
\arguments{
\item{obsWSAF}{Observed allele frequency within sample}

\item{exclusive}{When TRUE 0 < WSAF < 1; otherwise 0 <= WSAF <= 1.}

\item{title}{Histogram title}
}
\value{
histogram
}
\description{
Produce histogram of the allele frequency within sample.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageTxt = extractCoverageFromTxt(refFile, altFile)
obsWSAF = computeObsWSAF( PG0390CoverageTxt$altCount, PG0390CoverageTxt$refCount )
histWSAF(obsWSAF)
myhist = histWSAF(obsWSAF, FALSE)

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageVcf = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF( PG0390CoverageVcf$altCount, PG0390CoverageVcf$refCount )
histWSAF(obsWSAF)
myhist = histWSAF(obsWSAF, FALSE)

}

