# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Deconvolute mixed haplotypes
#'
#' @description Deconvolute mixed haplotypes, and reporting the mixture proportions from each sample
#' This function provieds an interface for calling \emph{dEploid} from R.
#' The command line options are passed via the \code{args} argument
#'
#' @section Seeding:
#' The R version of DEploid uses random number from R's random generator. Therefore, the '-seed'
#' argument of the command line version will be ignored, and no seed is given in the output. Use
#' the R function 'set.seed' prior to calling this function to ensure reproduciblity of results.
#'
#' @param args String of dEploid input.
#'
#' @seealso
#' \itemize{
#'   \item \code{vignette('dEploid-Arguments')} for an overview of commandline arguments
#' }
#'
#' @return A list with members of haplotypes, proportions and log likelihood of the MCMC chain.
#' \itemize{
#'   \item \code{Haps} Haplotypes at the final iteration in plain text file.
#'   \item \code{Proportions} MCMC updates of the proportion estimates.
#'   \item \code{llks} Log likelihood of the MCMC chain.
#' }
#'
#' @export
#'
#' @examples
#' \dontrun{
#' vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
#' plafFile = system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid")
#' set.seed(1234)
#' PG0390.deconv = dEploid(paste("-vcf", vcfFile, "-plaf", plafFile, "-noPanel"))
#' }
#'
dEploid <- function(args) {
    .Call(`_DEploid_dEploid`, args)
}

#' @title Extract VCF information
#'
#' @description Extract VCF information
#'
#' @param filename VCF file name.
#'
#' @seealso
#' \itemize{
#'   \item \code{extractCoverageFromVcf}
#'   \item \code{extractCoverageFromTxt}
#' }
#'
#' @return A dataframe list with members of haplotypes, proportions and log likelihood of the MCMC chain.
#' \itemize{
#'   \item \code{CHROM} SNP chromosomes.
#'   \item \code{POS} SNP positions.
#'   \item \code{refCount} reference allele count.
#'   \item \code{altCount} alternative allele count.
#' }
#'
#' @export
#'
#' @examples
#' vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
#' vcf = extractVcf(vcfFile)
#'
extractVcf <- function(filename) {
    .Call(`_DEploid_extractVcf`, filename)
}

test_RRG_sample <- function() {
    .Call(`_DEploid_test_RRG_sample`)
}

test_RRG_sampleUnitExpo <- function() {
    .Call(`_DEploid_test_RRG_sampleUnitExpo`)
}

test_RRG_sampleExpoExpoLimit <- function(lambda, b, limit) {
    .Call(`_DEploid_test_RRG_sampleExpoExpoLimit`, lambda, b, limit)
}

