% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegetation.R
\name{plant3D}
\alias{plant3D}
\title{Plant the trees of an already created patch/stand}
\usage{
plant3D(stand = NULL, patch.id = NULL, crown.opacity = 1)
}
\arguments{
\item{stand}{the stand for plantation}

\item{patch.id}{one or several specific patches only}

\item{crown.opacity}{alpha value for the green tree crowns. Setting it to something different than 1 slows down the rendering substatially!}
}
\value{
the updated stand
}
\description{
Plant the trees of an already created patch/stand
}
\examples{
\dontrun{
stand = initStand(npatch=2)
stand3D(stand, 1)
veg = data.frame(DBH=rep(0.4, 50))
veg$Height    = veg$DBH * 35
veg$Crownarea = veg$DBH * 5
veg$LeafType  = sample(1:2, nrow(veg), replace=TRUE)
veg$ShadeType = sample(1:2, nrow(veg), replace=TRUE)
stand@patches[[1]]@vegetation = establishTrees(veg, stand@hexagon@supp[['inner.radius']])
dummy = plant3D(stand, 1)

stand3D(stand, 2)
veg = data.frame(DBH=rep(0.5, 100) * rgamma(100, 2.5, 9))
veg$Height    = veg$DBH * 35  * rbeta(nrow(veg),10,1)
veg$Crownarea = veg$DBH * 5 * rnorm(nrow(veg), 1, 0.1)
veg$LeafType  = sample(1:2, nrow(veg), replace=TRUE)
veg$ShadeType = sample(1:2, nrow(veg), replace=TRUE)
stand@patches[[2]]@vegetation = establishTrees(veg, stand@hexagon@supp[['inner.radius']])
dummy = plant3D(stand, 2)
}
}
