% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{testUniformity}
\alias{testUniformity}
\title{Test for overall uniformity}
\usage{
testUniformity(simulationOutput, alternative = c("two.sided", "less",
  "greater"), plot = T)
}
\arguments{
\item{simulationOutput}{a DHARMa object with simulated residuals created with \code{\link{simulateResiduals}}}

\item{alternative}{a character string specifying whether the test should test if observations are "greater", "less" or "two.sided" compared to the simulated null hypothesis}

\item{plot}{if T, plots calls \code{\link{plotQQunif}} as well}
}
\description{
This function tests the overall uniformity of the simulated residuals in a DHARMa object
}
\details{
The function applies a KS test for uniformity on the simulated residuals
}
\seealso{
\code{\link{testResiduals}}, \code{\link{testDispersion}}, \code{\link{testZeroInflation}}, \code{\link{testGeneric}}, \code{\link{testTemporalAutocorrelation}}, \code{\link{testSpatialAutocorrelation}}
}
\author{
Florian Hartig
}
