% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{CalcOutput}
\alias{CalcOutput}
\title{Apply output control recommendations and calculate population dynamics}
\usage{
CalcOutput(y, TACused, TAC_f, lastCatch, availB, maxF, Biomass_P, VBiomass_P,
  CB_P, CB_Pret, FM_P, Z_P, Spat_targ, V_P, retA_P, M_ageArray, qs, nyears,
  nsim, maxage, nareas)
}
\arguments{
\item{y}{Projection year}

\item{TACused}{TAC recommendation}

\item{TAC_f}{Implementation error on TAC}

\item{lastCatch}{Catch from last year}

\item{availB}{Total available biomass}

\item{maxF}{Maximum fishing mortality}

\item{Biomass_P}{Numeric array (nsim, maxage, proyears, nareas) with Biomass at age}

\item{VBiomass_P}{Numeric array (nsim, maxage, proyears, nareas) with Vulnerable Biomass at age}

\item{CB_P}{Numeric array (nsim, maxage, proyears, nareas) with Catch Biomass at age}

\item{CB_Pret}{Numeric array (nsim, maxage, proyears, nareas) with Retained catch biomass at age}

\item{FM_P}{Numeric array (nsim, maxage, proyears, nareas) with fishing mortality at age}

\item{Z_P}{Numeric array (nsim, maxage, proyears, nareas) with total mortality at age}

\item{Spat_targ}{Spatial targetting}

\item{V_P}{Numeric array(nsim, maxage, nyears+proyears) with vulnerability at age}

\item{retA_P}{Numeric array(nsim, maxage, nyears+proyears) with retention at age}

\item{M_ageArray}{Numeric array (nsim, maxage, nyears+proyears) Natural mortality at age}

\item{qs}{Catchability coefficient}

\item{nyears}{Number of historical years}

\item{nsim}{Number of simulations}

\item{maxage}{Maximum age}

\item{nareas}{Number of areas}
}
\description{
Apply output control recommendations and calculate population dynamics
}
\author{
A. Hordyk
}
