% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{genLenComp}
\alias{genLenComp}
\title{Generate length composition of catch}
\usage{
genLenComp(CAL_bins, CAL_binsmid, SL, CAL_ESS, CAL_nsamp, CN, LaA, LaASD,
  truncSD)
}
\arguments{
\item{CAL_bins}{vector of catch-at-length size bins}

\item{CAL_binsmid}{vector (nbins = length(CAL_bins) - 1) of mid-points for catch-at-length size bins}

\item{SL}{matrix (nbins, nyears) of selectivity-at-length class for each year}

\item{CAL_ESS}{effective sample size of catch-at-length data}

\item{CAL_nsamp}{sample size of catch-at-length data}

\item{CN}{matrix (nyears, maxage) of catch-at-age for each year}

\item{LaA}{matrix (maxage, nyears) of expected length-at-age for each year}

\item{LaASD}{matrix (maxage, nyears) of standard deviation of length-at-age for each year}

\item{truncSD}{optional argument to truncate the length-at-age distribution at `truncSD` standard deviations 
e.g., a value of 2 truncates the length-at-age distribution at two standard deviations (set to 0 to ignore (default))}
}
\description{
Generate size composition of catch given sample of catch-at-age,
expected length-at-age, and standard deviation of length-at-age.
Model assumes length-at-age is normally distributed, and that
selectivity is size-dependant
}
