% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{Islope1}
\alias{Islope1}
\title{A management procedure that incrementally adjusts the TAC to maintain a
constant CPUE or relative abundance index}
\usage{
Islope1(x, Data, reps = 100, yrsmth = 5, lambda=0.4,xx=0.2)
}
\arguments{
\item{x}{A position in data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of TAC samples}

\item{yrsmth}{Years over which to smooth recent estimates of surplus production}

\item{lambda}{A gain parameter controlling the speed in update in TAC.}

\item{xx}{Parameter controlling the fraction of mean catch to start using in
first year}
}
\value{
A numeric vector of quota recommendations
}
\description{
The least biologically precautionary of two constant index / CPUE methods
proposed by Geromont and Butterworth 2014. Tested by Carruthers et al. 2015
}
\details{
Tested by Carruthers et al. 2015.
}
\references{
Carruthers et al. 2015. Performance review of simple management
procedures. Fish and Fisheries. In press.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci.
doi:10.1093/icesjms/fst232
}
\author{
T. Carruthers
}
