% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{Hist-class}
\alias{Hist-class}
\title{Class \code{'Hist'}}
\description{
An object for storing information generated by the end of the historical simulations
}
\section{Slots}{

\describe{
\item{\code{Data}}{The Data object at the end of the historical period}

\item{\code{Obs}}{A table of sampled parameters of the observation model. Table of nsim rows. Real numbers\cr
\itemize{

\item Abias: bias in observed current absolute stock biomass

\item Aerr: error in observed current absolute stock biomass

\item betas: hyper-stability/hyper-depletion parameter

\item BMSY_B0bias: bias in ratio of most productive stock size relative to unfished

\item Brefbias: bias in BMSY stock levels (target or reference biomass levels)

\item CAA_ESS: the effective sample size of multinomial catch-at-age observation model (number of independent draws)

\item CAA_nsamp: the number of catch-at-age observations per time step

\item CAL_ESS: the effective sample size of multinomial catch-at-length observation model (number of independent draws)

\item CAL_nsamp: the number of catch-at-length observations per time step

\item Cbias: bias in observed catches

\item Crefbias: bias in MSY prediction (target or reference catch)

\item Csd: observation error in observed catches (lognormal CV)

\item Dbias: bias in observed stock depletion (also applies to depletion Dt for DCAC)

\item Derr: error in observed stock depletion

\item FMSY_Mbias: bias in ratio of FMSY to natural mortality rate

\item hbias: bias in observed steepness of the stock recruitment relationship

\item Irefbias: bias in abundance index corresponding to BMSY stock levels

\item Isd: observation error in relative abundance index (lognormal CV)

\item Kbias: bias in maximum growth rate (von Bertalanffy K parameter)

\item lenMbias: bias in length at 50 per cent maturity

\item LFCbias: bias in length at first capture

\item LFSbias: bias in length at full selection

\item Linfbias: bias in maximum length (von Bertalanffy Linf parameter)

\item Mbias: bias in observed natural mortality rate

\item Recsd: error in observed recruitment

\item t0bias: bias in theoretical length at age zero (von Bertalanffy t0 parameter)

}}

\item{\code{OM}}{A numeric data.frame with nsim rows with sampled Stock & Fleet
parameters}

\item{\code{AtAge}}{A named list with arrays (dim nsim, maxage, nyears+proyears):
\itemize{
\item Length: Length-at-age for each simulation, age, and year
\item Weight: Weight-at-age for each simulation, age, and year
\item Select: Selectivity-at-age for each simulation, age, and year
\item Retention: Retention-at-age for each simulation, age, and year
\item Maturity: Maturity-at-age for each simulation, age, and year
\item N.Mortality: Natural mortality-at-age for each simulation, age, and year
\item Nage: Total numbers by simulation, age, and year
\item SSBage: Spawning stock biomass by simulation, age, and year
\item FM: Fishing mortality by simulation, age, year, and area
}}

\item{\code{TSdata}}{A named list with population dynamics by simulation and year :
\itemize{
\item VB: Vulnerable biomass
\item SSB: Spawning stock biomass
\item B: Total biomass
\item Removals: Removals
\item Catch: Retained catch (will be same as removals unless there is discard mortality)
\item Rec: Recruitment
\item N: Total numbers
\item Find: Historical fishing effort
\item Marray: Average adult natural mortality (historical & projection)
\item RecDev: Recruitment deviations (historical & projection)
}}

\item{\code{Ref}}{A numeric data.frame with nsim rows containing biological
reference points:
\itemize{
\item B0: Average unfished total biomass
\item Blow: Spawning stock biomass where it takes MGThorizon x MGT to
reach Bfrac of BMSY
\item BMSY: Average total biomass corresponding with MSY
\item BMSY_B0: Ratio of BMSY to B0
\item FMSY: Fishing mortality rate corresponding with MSY
\item FMSY_M: Ratio of FMSY to (adult) M
\item MGT: Mean generation time
\item MSY: Maximum sustainable yield
\item N0: Average unfished numbers
\item R0: Average unfished recruitment
\item RefY: Maximum yield obtained in forward projections with a fixed F
\item SSB0: Average unfished spawning biomass
\item SSBMSY: Average spawning biomass corresponding with MSY
\item SSBMSY_SSB: Ratio of SSBMSY to SSB0
\item UMSY: Exploitation rate corresponding with MSY
\item VBMSY: Average vulnerable biomass corresponding with MSY
}}

\item{\code{SampPars}}{All sampled Stock, Fleet, Obs, and Imp parameters}

\item{\code{Misc}}{A list of additional information}
}}

\author{
A. Hordyk
}
\keyword{classes}
