% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFitVPs}
\alias{dmcFitVPs}
\title{dmcFitVPs}
\usage{
dmcFitVPs(
  resOb,
  nTrl = 1e+05,
  startVals = list(),
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  fitInitialGrid = TRUE,
  fitInitialGridN = 10,
  fixedGrid = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  VP = c(),
  printInputArgs = TRUE,
  printResults = FALSE
)
}
\arguments{
\item{resOb}{Observed data (see flankerData, simonData for data format)}

\item{nTrl}{Number of trials to use within dmcSim}

\item{startVals}{Starting values for to-be estimated parameters}

\item{minVals}{Minimum values for the to-be estimated parameters}

\item{maxVals}{Maximum values for the to-be estimated parameters}

\item{fixedFit}{Fix parameter to starting value}

\item{fitInitialGrid}{TRUE/FALSE (NB. overrides fitInitialTau)}

\item{fitInitialGridN}{10}

\item{fixedGrid}{Fix parameter for initial grid search}

\item{nCAF}{Number of CAF bins.}

\item{nDelta}{Number of delta bins.}

\item{pDelta}{Alternative to nDelta by directly specifying required percentile values}

\item{VP}{NULL (aggregated data across all participants) or integer for participant number}

\item{printInputArgs}{TRUE/FALSE}

\item{printResults}{TRUE/FALSE}
}
\value{
dmcfitvp List of dmcfit per participant fitted (see dmcFitAgg)
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error (RMSE) between a weighted combination
of the CAF and CDF functions.
}
\examples{
\donttest{
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFitVPs(flankerData, nTrl = 1000, VP = c(1, 2))
plot(fit, flankerData, VP = 1)
plot(fit, flankerData, VP = 2)
summary(fit)
fitAgg <- mean(fit)
plot(fitAgg, flankerData)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFitVPs(simonData, nTrl = 1000, VP = c(1, 2))
plot(fit, simonData, VP = 1)
plot(fit, simonData, VP = 2)
summary(fit)
fitAgg <- mean(fit)
plot(fitAgg, simonData)
}

}
