% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{dmcCombineObservedData}
\alias{dmcCombineObservedData}
\title{dmcCombineObservedData: Combine results from dmcObservedData}
\usage{
dmcCombineObservedData(...)
}
\arguments{
\item{...}{Any number of outputs from dmcObservedData}
}
\value{
dmcobs
}
\description{
Combine observed datasets
}
\examples{
# Example 1
datFlanker <- dmcObservedData(flankerDataRaw, nDelta = 9)
datSimon <- dmcObservedData(simonDataRaw, nDelta = 9)
dat <- dmcCombineObservedData(datFlanker, datSimon)  # combine flanker/simon data
plot(dat, figType = "delta", xlimDelta = c(200, 700), 
     cols = c("black", "darkgrey"), pchs = c(1, 2), resetPar = FALSE)  
legend(200, 0, legend = c("Flanker Task", "Simon Task"), 
       col = c("black", "darkgrey"), lty = c(1, 1))

}
