\name{mvScatter}
\alias{mvScatter}

\title{
	Visualize the distributions of M-value pairs from differentially
	methylated CpG sites (DMC) or non-DMCs
}
\description{
	Given the M-values, True DMCs and optional the experiment design, 
	plot the scatter plot of M-values. DMCs are marked by red daggers and non-DMCs
	by green circles.
}
\usage{
mvScatter(mv, isDMC, pd = NULL, nPlot = 5000)
}

\arguments{
  \item{mv}{The input M-values matrix, NA is not allowed.
}

  \item{isDMC}{A binary vector corresponding to each row of 'mv'. 0 indicates non-DMC
  and 1 for DMC. 
}

  \item{pd}{A design matrix, which can be generated by 'stats::model.matrix'.
  If the M-values are totally paired or single paired, just leave it to be NULL.
}

  \item{nPlot}{The maximum number of loci to be plotted. Using too large value
  will lead to messy scatter and long execution time. Default is 5000.
}
}

\value{
	This function only generates a figure and has no return value.
}

\author{
	Linghao SHEN <sl013@ie.cuhk.edu.hk>
}

\examples{

	# mvScatter
	data(BLCA)
	mvScatter(BLCA$mv, BLCA$truth, nPlot = 10000)
}

