% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sim.q}
\alias{sim.q}
\title{Estimate LR exceedance probabilities (with importance sampling)}
\usage{
sim.q(t, dists, N = 1e+05, dists.sample = dists)
}
\arguments{
\item{t}{numeric (vector), threshold}

\item{dists}{list of per-locus probability distributions of a likelihood ratio}

\item{N}{integer, number of samples}

\item{dists.sample}{if dists.sample is not equal to dists, then importance sampling is applied. Sampling is done according to dists.sample, while exceedance probabilities are estimated for dists.}
}
\value{
numeric (vector) with estimated probabilities
}
\description{
Estimate LR exceedance probabilities (with importance sampling)
}
\details{
For a combined likelihood ratio \deqn{LR=LR_1 LR_2 \times LR_m,}
define \eqn{q_{t|H}} as the probability that the LR exceeds \eqn{t} under hypothesis \eqn{H}, i.e.:
\deqn{q_{t|H} := P(LR>t|H).}
The hypothesis \eqn{H} can be \eqn{H_p}, \eqn{H_d} or even another hypothesis. The current function estimates \eqn{q_{t|H}} by taking \eqn{N} samples from the distributions specified by the \code{dists} parameter and computing the empirical fraction of the product of the samples that exceeds \eqn{t}.

Importance sampling can be used by supplying different distributions to sample from and to estimate the exceedance probabilities for. For instance, the exceedance probability for \eqn{H_d} can be estimated by sampling from \eqn{H_p} and an appropriate weighting of the samples. See the paper and examples for details.
}
\examples{
data(freqsNLngm)

# dist of PI for true parent/offspring pairs
hp <- ki.dist(hyp.1="PO",hyp.2="UN",hyp.true="PO",freqs.ki=freqsNLngm)

# dist of PI for unrelated pairs
hd <- ki.dist(hyp.1="PO",hyp.2="UN",hyp.true="UN",freqs.ki=freqsNLngm)

set.seed(100)

# estiamte P(PI>1e6) for true PO
sim.q(t=1e6,dists=hp)

# estimate P(PI>1e6) for unrelated pairs
sim.q(t=1e6,dists=hd) # small probability, so no samples exceed t=1e6

# importance sampling can estimate the small probability reliably
# by sampling from H_p and weighting the samples appropriately
sim.q(t=1e6,dists=hd,dists.sample=hp)
}

