% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSObject.R
\name{dsGetInfo}
\alias{dsGetInfo}
\title{Get DataSHIELD-aware data repository metadata}
\usage{
dsGetInfo(dsObj, ...)
}
\arguments{
\item{dsObj}{An object inheriting from \code{\link{DSObject-class}},
i.e. \code{\link{DSDriver-class}}, \code{\link{DSConnection-class}},
or a \code{\link{DSResult-class}}.}

\item{...}{Other arguments to methods.}
}
\value{
a named list
}
\description{
Get DataSHIELD-aware data repository metadata
}
\section{Implementation notes}{

For `DSDriver` subclasses, this should include the version of the
package (`driver.version`) and the version of the underlying client
library (`client.version`).

For `DSConnection` objects this should report the version of
the data repository application (`repo.version`) and its name (`repo.name`),
the database name (`dbname`), username, (`username`), host (`host`), port (`port`), etc.
It MAY also include any other arguments related to the connection
(e.g., thread id, socket or TCP connection type). It MUST NOT include the
password.

For `DSResult` objects, this should include the R expression
being executed (`expression`) and if the query is complete (`has.completed`).
}

\seealso{
Other DSDriver generics: 
\code{\link{DSDriver-class}},
\code{\link{dsConnect}()}

Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}

Other DSResult generics: 
\code{\link{DSResult-class}},
\code{\link{dsFetch}()}
}
\concept{DSConnection generics}
\concept{DSDriver generics}
\concept{DSResult generics}
