% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newton.raphson.R
\name{newton.raphson}
\alias{newton.raphson}
\title{A dose titration algorithm (DTA) 'factory' based on the Newton-Raphson
heuristic}
\usage{
newton.raphson(dose1, omega, slope1, slopeU)
}
\arguments{
\item{dose1}{The starting dose for titration}

\item{omega}{A relaxation parameter used to moderate dose increments}

\item{slope1}{Dose-response slope assumed prior to 2nd measured neutrophil
nadir}

\item{slopeU}{Upper bound imposed on slope estimates}
}
\value{
A dose titration function that advises dose for next cycle of
chemotherapy.
}
\description{
This higher-order ('factory') function produces a simple dose titration
algorithm for neutrophil-guided chemotherapy dosing.
}
\details{
This function manifests the core concept of Dose Titration Algorithm Tuning
by delivering an objectively realized 'DTA'. It therefore enables a variety
of DTAs to be implemented and compared.
}
\seealso{
\code{\link{titrate}}
}
\author{
David C. Norris
}
