\name{acc.1test}
\alias{acc.1test}
\title{Accuracy of a Single Binary Diagnostic Test}
\description{
Sensitivity and specificity, (positive and negative) predictive values and (positive and negative) diagnostic likelihood ratios of a single binary diagnostic test.}

\usage{
acc.1test(tab, alpha, testname, ...)
}
\arguments{
  \item{tab}{An object of class \code{\link{tab.1test}}.
  }
  \item{alpha}{Significance level alpha for 100(1-alpha)\%-confidence intervals, the default is 0.05.
  }
  \item{testname}{A character variable containing the name of the diagnostic test. 
  }
  \item{\dots}{Additional arguments, usually not required.
  }
}
\details{
The calculation of accuracy measures and their variances follows standard methodology, e.g. described in Pepe (2003) or Zhou et al. (2011).
}
\value{An list of class \code{\link{tab.1test}}.
\item{tab}{A contingency table (matrix) of test results; the same \code{tab} that is supplied as an argument. 
 \tabular{lrrr}{
          \tab Diseased \tab Non-diseased \tab Total \cr
 Test pos. \tab ...      \tab ...          \tab ... \cr
 Test neg. \tab ...      \tab ...          \tab ... \cr
 Total     \tab ...      \tab ...          \tab ... 
 }
} 
\item{sensitivity }{A numeric vector containing the estimated sensitivity (\code{est}), its standard error (\code{se}), lower confidence limit (\code{lcl}) and upper confidence limit (\code{ucl}).}
\item{specificity }{A numeric vector containing the estimated specificity (\code{est}), its standard error (\code{se}), lower confidence limit (\code{lcl}) and upper confidence limit (\code{ucl}).}
\item{ppv }{A numeric vector containing the estimated positive predictive value (\code{est}), its standard error (\code{se}), lower confidence limit (\code{lcl}) and upper confidence limit (\code{ucl}).}
\item{npv }{A numeric vector containing the estimated negative predictive value (\code{est}), its standard error (\code{se}), lower confidence limit (\code{lcl}) and upper confidence limit (\code{ucl}).}
\item{pdlr }{A numeric vector containing the estimated positive diagnostic likelihood ratio (\code{est}), the standard error of the logarithm of the positive diagnostic likelihood ratio (\code{se.ln}), the lower confidence limit (\code{lcl}) and the upper confidence limit (\code{ucl}).}
\item{ndlr }{A numeric vector containing the estimated negative diagnostic likelihood ratio (\code{est}), the standard error of the logarithm of the negative diagnostic likelihood ratio (\code{se.ln}), the lower confidence limit (\code{lcl}) and the upper confidence limit (\code{ucl}).}
\item{alpha }{The significance level alpha used to compute 100(1-alpha)\%-confidence intervals, the default is 0.05.}
\item{testname }{A character variable containing the name of the diagnostic test. }
}

\references{
Zhou, X., Obuchowski, N., and McClish, D. (2011). Statistical Methods in Diagnostic Medicine. Wiley Series in Probability and Statistics. John Wiley & Sons, Hoboken, New Jersey, 2nd edition.

Pepe, M. (2003). The statistical evaluation of medical tests for classifcation and prediction. Oxford Statistical Science Series. Oxford University Press, 1st edition.
}

\seealso{
\code{\link{tab.1test}},
\code{\link{print.acc.1test}},
\code{\link{acc.paired}}.
}
\examples{
data(Paired1) # Hypothetical study data 
a1 <- tab.1test(d=d, y=y1, data=Paired1)
a2 <- acc.1test(a1)
print(a2)
}
