% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp2.R
\name{Chapter02}
\alias{Chapter02}
\alias{print_stats}
\alias{print_freqs}
\title{Chapter 2}
\usage{
print_stats(x, na.rm = TRUE)

print_freqs(x, breaks, include.lowest = TRUE, right = TRUE)
}
\arguments{
\item{x}{\link[base]{numeric} vector, the observations. 
In \link{print_freqs} function, this argument can also be a \link[base]{factor}}

\item{na.rm}{\link[base]{logical} scalar, whether to remove the missing observations (default \code{TRUE})}

\item{breaks, include.lowest, right}{see \link[base]{cut.default}. Note that we use default
\code{include.lowest = TRUE} in \link{print_freqs}}
}
\value{
\link{print_freqs} returns a \code{'freqs'} object, for which
a \link[base]{print} method, a \link[ggplot2]{autolayer} and a \link[ggplot2]{autoplot} method are defined.

\link{print_stats} does not have a returned value.
}
\description{
Functions and examples for Chapter 2, \emph{Descriptive Statistics}.
}
\details{
\link{print_freqs} prints the (relative) frequencies and cumulative (relative) frequencies, from 
a numeric input vector, specified interval breaks as well as open/close status of the ends of the intervals.

\link{print_stats} prints the simple statistics of the input observations, such as sample size,
mean, median, (smallest) mode, variance, standard deviation, 
coefficient of variation (if all observations are non-negative),
quartiles, inter-quartile range (IQR), range, skewness and kurtosis.  A histogram is also printed.
}
\examples{
library(DanielBiostatistics10th)
# To run a line of code, use shortcut
# Command + Enter: Mac and RStudio Cloud
# Control + Enter: Windows, Mac and RStudio Cloud
# To clear the console
# Control + L: Mac and RStudio Cloud

# To view the help files
# ?Chapter02

# Page 20, Example 2.2.1
d141 = read.csv(system.file('extdata', 'EXA_C01_S04_01.csv', package = 'DanielBiostatistics10th'))
head(d141)
class(d141$AGE) # 'integer'
class(age <- as.numeric(d141$AGE)) # 'numeric'
sort(age) # Page 21, Table 2.2.1 # 'ordered vector'

# Page 23, Example 2.3.1
(ageB = seq.int(from = 30, to = 90, by = 10))
(r231 = print_freqs(age, breaks = ageB, right = FALSE)) # Page 25, Table 2.3.2
autoplot(r231, title = 'Page 27, Figure 2.3.2')
# read ?base::cut and ?graphics::hist 
# `include.lowest` actually implies 'include.highest' when `right = FALSE`
# The open/close of interval ends is determined by textbook using 30-39, 40-49, etc.

# Page 38, Example 2.4.1
# Page 39, Example 2.4.2
# Page 40, Example 2.4.3
# Page 40, Example 2.4.4
# Page 41, Example 2.4.5
# Page 42, Example 2.4.6
# Page 44, Example 2.5.1
# Page 44, Example 2.5.2
# Page 46, Example 2.5.3
print_stats(age) # or some other data input

# Page 49, Example 2.5.4 (omitted)

# Page 50, Example 2.5.5
d255 = read.csv(system.file('extdata', 'EXA_C02_S05_05.csv', package = 'DanielBiostatistics10th'))
head(d255)
boxplot(d255$GRF, main = c('GRF from Page 50, Example 2.5.5'))
print_stats(d255$GRF)
print_freqs(d255$GRF, breaks = seq.int(10, 45, by = 5))
}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
\seealso{
\link[base]{cut.default} \link[base]{table} \link[base]{cumsum}
\link[base]{mean.default} \link[stats]{median.default} \link[pracma]{Mode} 
\link[stats]{var} \link[stats]{sd} \link[stats]{quantile}
\link[e1071]{skewness} \link[e1071]{kurtosis}
}
