% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_conf.R
\name{number_of_rows}
\alias{number_of_rows}
\alias{nrows_simul_constant}
\alias{nrows_simul_ratio}
\title{Methods for extracting number of target rows in simulation}
\usage{
nrows_simul_constant(n, force = FALSE)

nrows_simul_ratio(ratio, total, force = FALSE)
}
\arguments{
\item{n}{Default number of rows for each table when not defined in configuration file.}

\item{force}{Should specified parameters overwrite related configuration parameters?}

\item{ratio, total}{The parameters multiplications results with defining target
number of rows for simulated table. See details section.}
}
\description{
Each method returns function of list of tables.
The value of such function is named list being mapping between tables
(names of list) and target number of rows (values of list).
Such methods can be passed as \code{nrows} parameter of \link{opt_default_table}.
}
\details{
Currently supported methods are:
\itemize{
  \item{nrows_simul_constant}{
    Returns \code{n} rows for each table when not defined in YAML parameter \code{nrows}
  }
  \item{nrows_simul_ratio}{
    Returns \code{nrows * ratio} when \code{nrows} defined as YAML parameter and is integer.
    Returns \code{nrows} when \code{nrows} defined as YAML parameter and id fraction,
    Returns \code{n * ratio} otherwise.
  }
}
}
