% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_imf.R
\name{plot_imf}
\alias{plot_imf}
\title{Plot IMFs characteristics}
\usage{
plot_imf(
  pulse,
  dtlim = NULL,
  xylim = NULL,
  flim = NULL,
  fclim = NULL,
  dtline = NULL,
  fline = NULL,
  fcline = NULL,
  vertical = FALSE,
  n = 10,
  at.maj = NULL,
  ls = list(type = "o", pch = 19),
  le1 = list(lwd = 2),
  le2 = list(lty = 2),
  lid = list(type = "p", pch = 19),
  lcos = list(),
  ldt = list(lty = 5, lwd = 2),
  lf = list(lty = 5),
  lfc = list(lty = 5),
  box = TRUE
)
}
\arguments{
\item{pulse}{a pulse object}

\item{dtlim, xylim, flim, fclim}{the boundaries for the plots, respectively for
the depth/time, amplitude, frequency and freqeuncy carrier}

\item{dtline, fline, fcline}{coordinates to add vertical/horizontal lines}

\item{vertical}{whether to have the depth/time [dt] axis vertically}

\item{n}{the the number of intervals defined by minor ticks
(geologist convention) or horizontaly (climatologist convention)}

\item{at.maj}{the positions at which major tick-marks are to be drawn.}

\item{ls, le1, le2, lid, lcos}{lists of parameters to feed lines, for the
original signal, the upper and lower envelope, the identity tuning, and the
cosine line in the identity tuning}

\item{ldt, lf, lfc}{lists of parameters to provide the abline function (makes
personalised lines for you to have a better grasp of the data).}

\item{box}{whether to draw boxes around the plots}
}
\description{
General plot for the envelope, instantaneous frequency (period)
and identity tuning of an intrinsic mode function (IMF)
}
\details{
the line in the identity tuning plot is a genuine cosine,
independent from the signal. This is evident when riding waves generate
dephasing.
}
\examples{
n <- 600

t <- seq_len(n)

p1 <- 30
p2 <- 40 * 21

am <- sin(t*2*pi/p2 + 50) + 0.03

xy <- sin(t*2*pi/p1 + 50) * 3 * am

int <- c(rep(1, 99 + 100), seq(1,3,2/100), seq(3,1,-2/100), rep(1,100 + 99))

dt <- cumsum(int)

samp <- approx(dt, xy, xout = seq(1,802, by = 2))

xy <- samp$y
dt <- samp$x

e <- normalise(m = xy, dt = dt)$a

cond <- dt < 75

xy <- xy[!cond]
dt <- (dt[!cond] - 75) / 1.2
e  <- e[!cond]

dq   <- dq.algorithm(xy/e, dt)

pulse <- as.pulse(dt = dt, m = xy, f = dq$f, a = e, idt = dq$idt,
                  repl = 1)

plot_imf(pulse, fline = 25, dtline = c(222, 489))

}
