% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depthContour.R
\name{depthContour}
\alias{depthContour}
\title{Approximate depth contours}
\usage{
depthContour(x, xlim = extendrange(x[, 1], f = 0.1),
  ylim = extendrange(x[, 2], f = 0.1), n = 50, pmean = TRUE,
  mcol = "blue", pdmedian = TRUE, mecol = "brown", legend = TRUE,
  points = FALSE, colors = heat_hcl, levels = 10,
  depth_params = list(), graph_params = list())
}
\arguments{
\item{x}{Bivariate data}

\item{xlim}{Determines the width of x-axis.}

\item{ylim}{Determines the width of y-axis.}

\item{n}{Number of points in each coordinate direction to be used in contour plot.}

\item{pmean}{Logical. If TRUE mean will be marked.}

\item{mcol}{Determines the color of lines describing the mean.}

\item{pdmedian}{Logical. If TRUE depth median will be marked.}

\item{mecol}{Determines the color of lines describing the depth median.}

\item{legend}{Logical. If TRUE legend for mean and depth median will be drawn.}

\item{points}{Logical. If TRUE points from matrix x will be drawn.}

\item{colors}{function for colors pallete (e.g. gray.colors).}

\item{levels}{number of levels for color scale.}

\item{depth_params}{list of parameters for function depth (method, threads, ndir, la, lb, pdim, mean, cov, exact).}

\item{graph_params}{list of graphical parameters for functions filled.contour and contour (e.g. lwd, lty, main).}
}
\description{
Draws an approximate contours of depth for bivariate data.
}
\details{
The set of all points that have depth at least \eqn{ \alpha } is called \eqn{ \alpha }-trimmed region. The \eqn{ \alpha }-trimmed region w.r.t. \eqn{ F } is denoted by \eqn{ {D}_{\alpha}(F) }, i.e., \deqn{ {D}_{\alpha}(F) = \left\{ z \in {{{R}} ^ {d}}:D(z, F) \ge \alpha\right\}. }
}
\examples{
# EXAMPLE 1
x <- mvrnorm(1000, c(0, 0), diag(2))
depthContour(x, colors = gray.colors)
# with points
depthContour(x, points = TRUE)
depthContour(x, points = FALSE, levels = 10)

# EXAMPLE 2
data(inf.mort, maesles.imm)
data1990 <- na.omit(cbind(inf.mort[, 1], maesles.imm[, 1]))
depthContour(data1990, n = 50, pmean = TRUE, mcol = "blue",
             pdmedian = TRUE, mecol = "brown", legend = TRUE, points = TRUE,
             depth_params = list(method = "LP"),
             graph_params = list(
               xlab = "infant mortality rate per 1000 live birth",
               ylab = "against masles immunized percentage",
               main = "L2 depth, UN Fourth Goal 2011 year"))

}
\seealso{
\code{\link{depthPersp}}
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{contour}
\keyword{depth}
