\name{GoodmanKruskalTauA}
\alias{GoodmanKruskalTauA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Goodman Kruskal's Tau a
%%  ~~function to do ... ~~
}
\description{Calculate Goodman Kruskal's tau-a statistic, a measure of
association for ordinal factors in a two-way table.\cr
The function has interfaces for a table (matrix) and for single vectors.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
GoodmanKruskalTauA(x, y = NULL, direction = c("row", "column"), conf.level = NA, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a numeric vector or a table. A matrix will be treated as table.
%%     ~~Describe \code{x} here~~
}
  \item{y}{NULL (default) or a vector with compatible dimensions to \code{x}. If y is provided, \code{table(x, y, \dots)} is calculated.
%%     ~~Describe \code{y} here~~
}
 \item{direction}{direction of the calculation. Can be \code{"row"} (default) or \code{"column"}, where
  \code{"row"} calculates Goodman Kruskal's tau-a (R|C) ("column dependent").
%%     ~~Describe \code{x} here~~
}
\item{conf.level}{confidence level of the interval. If set to NA (which is the default) no confidence interval will be calculated. 
%%     ~~Describe \code{conf.level} here~~
}
  \item{\dots}{further arguments are passed to the function \code{\link{table}}, allowing i.e. to set useNA. This refers only to the vector interface.
%%     ~~Describe \code{\dots} here~~
}
}
\details{
Goodman and Kruskal's tau-a is a measure of categorical association which is based entirely on the observed data and possesses a clear interpretation in terms of proportional reduction in error.
It gives the probabilities of correctly assigning cases to one set of categories improved by the knowledge of another set of categories. The statistic is asymmetric and yields different results predicting row assignments based on columns than from column assignments based on rows.\cr
The range of Goodman Kruskal's tau is [0, 1] and is computed as\cr
TauA(C|R) = (P-Q)/(n(n-1)/2)), where P equals twice the number of concordances and Q twice the number of discordances. 
Goodman Kruskal tau reduces to Phi^2 in the 2x2-table case.\cr
(Note that Goodman Kruskal tau-a does not take into consideration any ties, which makes it unpractical.)   
%%  ~~ If necessary, more details than the description above ~~
}
\value{
a single numeric value if no confidence intervals are requested,\cr 
and otherwise a numeric vector with 3 elements for the estimate, the lower and the upper confidence interval
}
\references{
Agresti, A. (2002) \emph{Categorical Data Analysis}. John Wiley & Sons, 
pp. 57-59.

Goodman, L. A., & Kruskal, W. H. (1954) Measures of
association for cross classifications. \emph{Journal of the
American Statistical Association}, 49, 732-764.

Somers, R. H. (1962) A New Asymmetric Measure of Association for Ordinal Variables, \emph{American Sociological Review}, 27, 799-811.

Goodman, L. A., & Kruskal, W. H. (1963) Measures of
association for cross classifications III: Approximate
sampling theory. \emph{Journal of the American Statistical
Association}, 58, 310-364.

\url{http://support.sas.com/onlinedoc/913/getDoc/en/statug.hlp/freq_sect18.htm}\cr
\url{http://support.sas.com/onlinedoc/913/getDoc/en/statug.hlp/freq_sect20.htm}
%% ~put references to the literature/web site here ~
}

\author{Andri Signorell <andri@signorell.net>, based on code from Antti Arppe <antti.arppe@helsinki.fi>
%%  ~~who you are~~
}

\seealso{\code{\link{ConDisPairs}} yields concordant and discordant pairs \cr\cr
Other association measures: \cr
\code{\link{GoodmanKruskalTauA}} (Tau a), \code{\link{cor}} (method="kendall") for Tau b, \code{\link{StuartTauC}}, \code{\link{GoodmanKruskalGamma}}\cr
\code{\link{Lambda}}, \code{\link{UncertCoef}}, \code{\link{MutInf}} 

%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{

# example in: 
# http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf
# pp. S. 1821

tab <- as.table(rbind(c(26,26,23,18,9),c(6,7,9,14,23)))

# Goodman Kruskal's tau-a C|R
GoodmanKruskalTauA(tab, direction="column", conf.level=0.95)
# Goodman Kruskal's tau-a R|C
GoodmanKruskalTauA(tab, direction="row", conf.level=0.95)

# http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf
# pp. 1814 (143)
tab <- as.table(cbind(c(11,2),c(4,6)))

GoodmanKruskalTauA(tab, direction="row", conf.level=0.95)
GoodmanKruskalTauA(tab, direction="column", conf.level=0.95)
# reduces to:
Phi(tab)^2

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ multivar}
\keyword{nonparametric}
