% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/graphviz_export.R
\name{exportSVG}
\alias{exportSVG}
\title{Export grViz graph as SVG with \code{V8}}
\usage{
exportSVG(gv)
}
\arguments{
\item{gv}{htmlwidget to render as SVG.}
}
\value{
\code{string} of SVG XML text.
}
\description{
Use viz.js with \code{V8} to get the diagram rendered
as SVG in R instead of the browser.
}
\examples{
\dontrun{
 library(DiagrammeR)
 (svg <- exportSVG(grViz('digraph{a->b; c->a; c->b; c->d;}', engine = 'circo')))

 # this can then be used with htmltools
 #   can save significantly on size of output
 #   using svg rather than unrendered grViz
 library(htmltools)
 html_print(HTML(svg))
}
}

