% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_nodes.R
\name{create_nodes}
\alias{create_nodes}
\title{Create a data frame with nodes and their attributes}
\usage{
create_nodes(nodes, type = NULL, label = nodes, ...)
}
\arguments{
\item{nodes}{the node ID value(s) for the node(s)
to be created.}

\item{type}{an optional \code{type} label for each
node.}

\item{label}{an optional label for each node.}

\item{...}{one or more named vectors for associated
attributes.}
}
\value{
a node data frame (ndf).
}
\description{
Combine several named vectors for nodes
and their attributes into a data frame, which can be
combined with other similarly-generated data frames,
or, added to a graph object.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = 1:4,
    type = "a",
    label = TRUE,
    style = "filled",
    color = "aqua",
    shape = c("circle", "circle",
              "rectangle", "rectangle"),
    value = c(3.5, 2.6, 9.4, 2.7))

# Display the `nodes` ndf
nodes
#>   nodes type label  style color     shape value
#> 1     1    a     1 filled  aqua    circle   3.5
#> 2     2    a     2 filled  aqua    circle   2.6
#> 3     3    a     3 filled  aqua rectangle   9.4
#> 4     4    a     4 filled  aqua rectangle   2.7
}

