% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_walktrap.R
\name{get_cmty_walktrap}
\alias{get_cmty_walktrap}
\title{Get community membership using the Walktrap method}
\usage{
get_cmty_walktrap(graph, steps = 4)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{steps}{the number of steps to take for each
of the random walks.}
}
\value{
a data frame with group membership
assignments for each of the nodes.
}
\description{
With the Walktrap community finding
algorithm, obtain the group membership values for
each of the nodes in the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the group membership values for all nodes
# in the graph through the Walktrap community
# finding algorithm
get_cmty_walktrap(graph)
#>    id walktrap_group
#> 1   1              1
#> 2   2              1
#> 3   3              1
#> 4   4              2
#> 5   5              1
#> 6   6              2
#> 7   7              1
#> 8   8              1
#> 9   9              2
#> 10 10              1

# Add the group membership values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(get_cmty_walktrap(.))
}

