% Generated by roxygen2 (4.0.2): do not edit by hand
\name{branin2}
\alias{branin2}
\title{2D test function}
\usage{
branin2(x)
}
\arguments{
\item{x}{a 2-dimensional vector specifying the location where the function
is to be evaluated.}
}
\value{
A real number equal to the branin2 function values at \code{x}
}
\description{
Branin 2-dimensional test function (standardized version).
}
\details{
The branin2 (standardized version) function is defined over the domain
\code{[0,1]^2}. It has 3 global minimizers : x*,1 = c(0.1239, 0.8183), x*,2
= c(0.5428, 0.1517), x*.3 = c(0.9617, 0.1650), with minimum f(x*,i) =
-1.047410
}
\examples{
design <- matrix(runif(200), 200, 2)
response <- apply(design, 1, branin2)
}
\author{
Tobias Wagner

Victor Picheny

David Ginsbourger
}
\keyword{internal}
\keyword{optimize}

