% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-ContainerProvider.R,
%   R/dummyContainer.R
\name{configServerContainerEnv}
\alias{configServerContainerEnv}
\alias{configServerContainerEnv,DummyContainer-method}
\title{Configurate the server container environment}
\usage{
configServerContainerEnv(container, cluster, verbose)

\S4method{configServerContainerEnv}{DummyContainer}(container, cluster, verbose = FALSE)
}
\arguments{
\item{container}{Reference Container Object. The server container.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
An object which has the same class as \code{container}
}
\description{
Configurate the server container environment. Developers can use this function
to set the server password, port number and etc. via the container environment variable.
The server info can be found by the getter function with the prefix \code{.getServer}
(e.g. \code{.getServerPassword(cluster)}).
The developer \emph{must} calls \code{container$copy()} before
setting the server environment. The user provided environment variables should
be respected and overwritten only when necessary.
There is no default method for this generic.
}
\section{Functions}{
\itemize{
\item \code{configServerContainerEnv,DummyContainer-method}: method for the dummy container
}}

