% Generated by roxygen2: do not edit by hand
\name{cm13}
\alias{cm13}
\title{One-Sample Covariance Test by Cai and Ma (2013)}
\usage{
cm13(X,Sigma0, alpha)
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{alpha}{level of significance.}
}
\value{
a named list containing: \describe{
\item{statistic}{a test statistic value.}
\item{threshold}{rejection criterion to be compared against test statistic.}
\item{reject}{a logical; \code{TRUE} to reject null hypothesis, \code{FALSE} otherwise.}
}
}
\description{
Given data, it performs 1-sample test for Covariance where
the null hypothesis is
\deqn{H_0 : \Sigma_n = \Sigma_0}
where \eqn{\Sigma_n} is the covariance of data model and \eqn{\Sigma_0} is a
hypothesized covariance based on a procedure proposed by Cai and Ma (2013).
}
\examples{
## generate data from multivariate normal with trivial covariance.
p = 5;n=10
X=data = matrix(rnorm(n*p), ncol=p)
alpha=0.05
Sigma0=diag(ncol(X))
cm13(X,Sigma0, alpha)
}

