% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmericanPutPriceBinomial.R
\name{AmericanPutPriceBinomial}
\alias{AmericanPutPriceBinomial}
\title{Binomial Put Price}
\usage{
AmericanPutPriceBinomial(stockPrice, strike, r, sigma, maturity, numberSteps)
}
\arguments{
\item{stockPrice}{Stock price of underlying stock}

\item{strike}{Strike price of the option}

\item{r}{Risk-free rate}

\item{sigma}{Volatility of the underlying stock and is in annualised
term}

\item{maturity}{The term to maturity of the option in days}

\item{numberSteps}{The number of time-steps in the binomial tree}
}
\value{
Binomial American put price
}
\description{
Estimates the price of an American Put, using the binomial approach.
}
\examples{
# Estimates the price of an American Put
   AmericanPutPriceBinomial(27.2, 25, .03, .2, 60, 30)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Lyuu, Yuh-Dauh. Financial Engineering & Computation: Principles,
Mathematics, Algorithms, Cambridge University Press, 2002.
}

