% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BlackScholesCallPrice.R
\name{BlackScholesCallPrice}
\alias{BlackScholesCallPrice}
\title{Price of European Call Option}
\usage{
BlackScholesCallPrice(stockPrice, strike, rf, sigma, t)
}
\arguments{
\item{stockPrice}{Stock price of underlying stock}

\item{strike}{Strike price of the option}

\item{rf}{Risk-free rate and is annualised}

\item{sigma}{Volatility of the underlying stock}

\item{t}{The term to maturity of the option in years}
}
\value{
Price of European Call Option
}
\description{
Derives the price of European call option using the Black-Scholes approach
}
\examples{
# Estimates the price of an American Put
   BlackScholesCallPrice(27.2, 25, .03, .2, 60)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Hull, John C.. Options, Futures, and Other Derivatives. 5th ed., p. 246.

Lyuu, Yuh-Dauh. Financial Engineering & Computation: Principles,
Mathematics, Algorithms, Cambridge University Press, 2002.
}

