% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ShortBlackScholesCallVaR.R
\name{ShortBlackScholesCallVaR}
\alias{ShortBlackScholesCallVaR}
\title{Derives VaR of a short Black Scholes call option}
\usage{
ShortBlackScholesCallVaR(stockPrice, strike, r, mu, sigma, maturity, cl, hp)
}
\arguments{
\item{stockPrice}{Stock price of underlying stock}

\item{strike}{Strike price of the option}

\item{r}{Risk-free rate and is annualised}

\item{mu}{Mean return}

\item{sigma}{Volatility of the underlying stock}

\item{maturity}{Term to maturity and is expressed in days}

\item{cl}{Confidence level and is scalar}

\item{hp}{Holding period and is scalar and is expressed in days}
}
\value{
Price of European Call Option
}
\description{
Function derives the VaR of a short Black Scholes call for specified
confidence level and holding period, using analytical solution.
}
\examples{
# Estimates the price of an American Put
   ShortBlackScholesCallVaR(27.2, 25, .03, .12, .2, 60, .95, 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Hull, John C.. Options, Futures, and Other Derivatives. 4th ed., Upper Saddle
River, NJ: Prentice Hall, 200, ch. 11.

Lyuu, Yuh-Dauh. Financial Engineering & Computation: Principles,
Mathematics, Algorithms, Cambridge University Press, 2002.
}

