% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcessDensOpt.R
\docType{class}
\name{postProcessDensOpt}
\alias{postProcessDensOpt}
\title{Density Optimization}
\usage{
postProcessDensOpt(dyncomm,Parameters)
}
\arguments{
\item{dyncomm}{a DynCom post processing algorithm. See \code{\link{DynCommPostProcess}}}

\item{Parameters}{A two column matrix defining the parameters for this 
algorithm. See the PARAMETERS section on this page}
}
\value{
\code{postProcessDensOpt} object
}
\description{
Implementation of the density optimization algorithm as a post processing
algorithm.
}
\details{
Is an algorithm that provides a community structure, not explicitly based on 
modularity, but based on the increase of the average community density. 
Contrary to modularity-based algorithms, it tends to disband large communities 
into smaller ones.
It is an algorithm currently developed for directed networks only.
}
\section{Performance}{

\describe{
  \item{Initialization}{
  Uses a matrix with three columns and a maximum of verticelAll()^2 rows 
  with the edges between vertices and their weight (vertex<->vertex<->weight)
  of the original graph.
  Temporarily stores a copy of the graph to calculate a new community mapping.
  }
  \item{Results}{
  Uses a matrix with two columns and verticesAll() rows with the new community
  mapping (vertex<->community).
  Uses a matrix with three columns and a maximum of 
  communityCount()^2+communityCount() rows with the edges between communities 
  and their weight (community<->community<->weight).
  }
}
}

\section{Methods}{

\describe{


  \item{results(differential)}{Get additional results of the algorithm or the currently selected post processing steps. See \code{\link{results}}}
  

  \item{quality()}{Get the quality measurement of the graph after the last iteration. See \code{\link{quality}}}
  

  \item{communityCount()}{Get the number of communities after the last iteration. See \link{communityCount}}
  

  \item{communities()}{Get all communities after the last iteration. See \link{communities}}
  

  \item{communitiesEdgeCount()}{Get the number of community to community edges in the graph. See \code{\link{communitiesEdgeCount}}}
  

  \item{communityNeighbours(community)}{Get the neighbours of the given community after the last iteration. See \link{communityNeighbours}}
  

  \item{communityInnerEdgesWeight(community)}{Get the sum of weights of the inner edges of the given community after the last iteration. See \link{communityInnerEdgesWeight}}
  

  \item{communityTotalWeight(community)}{Get the sum of weights of all edges of the given community after the last iteration. See \link{communityTotalWeight}}
  

  \item{communityEdgeWeight(source,destination)}{Get the weight of the edge that goes from source to destination after the last iteration. See \link{communityEdgeWeight}}
  

  \item{communityVertexCount(community)}{Get the amount of vertices in the given community after the last iteration. See \link{communityVertexCount}}
  

  \item{community(vertex)}{Get the community of the given vertex after the last iteration. See \link{community}}
  

  \item{vertexCount()}{Get the total number of vertices after the last iteration. See \link{vertexCount}}
  

  \item{verticesAll()}{Get all vertices in the graph after the last iteration. See \link{verticesAll}}
  

  \item{neighbours(vertex)}{Get the neighbours of the given vertex after the last iteration. See \link{neighbours}}
  

  \item{edgeWeight(source,destination)}{Get the weight of the edge that goes from source vertex to destination vertex after the last iteration. See \link{edgeWeight}}
  

  \item{vertices(community)}{Get all vertices belonging to the given community after the last iteration. See \link{vertices}}
  

  \item{communityMapping()}{Get the community mapping for all communities after the last iteration.See \link{communityMapping}}
  

  \item{communityMapping()}{Get the community mapping for all communities after the last iteration.See \link{communityMapping}}
  

}
}

\examples{
\dontrun{
Parameters<-matrix(c("-e","0.1"),1,2,TRUE)
dc<-DynCommMain(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdgesFile("initial_graph.txt")
dc$communityCount()
dc$communities()
dc$communityNodeCount(1)
dc$vertices(1)
dc$communityMapping(TRUE)
dc$time()
dc$addRemoveEdgesFile("s0000000000.txt")
}

}
\author{
poltergeist0
}
\keyword{internal}
