% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_TxSubsetInteger.R
\docType{methods}
\name{TxSubsetInteger-methods}
\alias{TxSubsetInteger-methods}
\alias{.convertFromBinary,TxSubsetInteger-method}
\alias{.convertToBinary,TxSubsetInteger-method}
\alias{.getPtsSubset,TxSubsetInteger-method}
\alias{.getSingleton,TxSubsetInteger-method}
\alias{.getSubsetRule,TxSubsetInteger-method}
\alias{.getSubsets,TxSubsetInteger-method}
\alias{.compareTx,TxSubsetInteger,integer,integer-method}
\alias{.convertTx,TxSubsetInteger-method}
\alias{.getLevels,TxSubsetInteger,integer-method}
\alias{.getSuperset,TxSubsetInteger-method}
\alias{.getTxName,TxSubsetInteger-method}
\alias{.validTx,TxSubsetInteger-method}
\title{Methods Available for Objects of Class \code{TxSubsetInteger}}
\usage{
\S4method{.convertFromBinary}{TxSubsetInteger}(txObj, txVec, ...)

\S4method{.convertToBinary}{TxSubsetInteger}(txObj, data, ...)

\S4method{.getPtsSubset}{TxSubsetInteger}(object)

\S4method{.getSingleton}{TxSubsetInteger}(object)

\S4method{.getSubsetRule}{TxSubsetInteger}(object)

\S4method{.getSubsets}{TxSubsetInteger}(object)

\S4method{.compareTx}{TxSubsetInteger,integer,integer}(object, vec1, vec2)

\S4method{.convertTx}{TxSubsetInteger}(object, txVec)

\S4method{.getLevels}{TxSubsetInteger,integer}(object, txVec)

\S4method{.getSuperset}{TxSubsetInteger}(object)

\S4method{.getTxName}{TxSubsetInteger}(object)

\S4method{.validTx}{TxSubsetInteger}(object, txVec)
}
\description{
Methods Available for Objects of Class \code{TxSubsetInteger}

\code{.convertFromBinary(txObj, txVec)}
  converts a -1/1 Tx to user provided tx coding.
  Call method defined for \code{TxSubset}.

\code{.convertToBinary(txObj, data)}
  converts user specified tx variable to binary -1/1.
  Call method defined for \code{TxSubset}.

\code{.getPtsSubset(object)}
 retrieve subset name for which each pt is a member.
  Call method defined for \code{TxSubset}.

\code{.getSingleton(object)}
  retrieve T/F indicator of only 1 tx option available to each pt.
  Call method defined for \code{TxSubset}.

\code{.getSubsetRule(object)}
  retrieve feasible set identification rule.
  Call method defined for \code{TxSubset}.

\code{.getSubsets(object)}
  retrieve subset names and tx options.
  Call method defined for \code{TxSubset}.

\code{.compareTx(object, vec1, vec2)}
  compares vec1 and vec2 to identify equivalent elements.

\code{.compareTx(object, vec1, vec2)}
  converts txVec to factor.

\code{.getLevels(object, txVec)}
  determines tx levels contains in txVec.

\code{.getSuperset(object)}
  retrieves superset. Uses method defined for TxInfoInteger objects.

\code{.getTxName(object)}
  retrieves tx variable name. Uses method defined for TxInfoInteger objects.

\code{.validTx(object, txVec)}
  ensures all elements in txVec are allowed by superset.
}
\keyword{internal}
