% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSCovL2sup.R
\name{KSCovsup}
\alias{KSCovsup}
\title{Sup-norm based test of equality of several covariance functions}
\usage{
KSCovsup(data, Nsim = 1000)
}
\arguments{
\item{data}{The list variable containing k groups of presmoothed functional observations. 
Each element of the list is a p (number sampling points) by n (sample size) matrix.}

\item{Nsim}{Number of pseudo samples by resampling, default=1000.}
}
\value{
The p-value of the test.
}
\description{
Sup-norm test of equality of several covariance functions, using resampling 
to approximate the null distribution.
}
\details{
Sup-norm test of equality of several covariance functions, see GUO et al. (2017).
}
\examples{
fdata<-list();
fdata[[1]]<-matrix(rnorm(200),20,10);
fdata[[1]]<-matrix(rnorm(300),20,15);
KSCovsup(fdata)
KSCovsup(fdata, 500)
}
\references{
GUO et al. (2017).
}
\seealso{
\code{\link{KSCovL2WS}}, \code{\link{KSCovL2}}.
}
