% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{manual_correction}
\alias{manual_correction}
\alias{reset_manual_correction}
\title{Manual correction}
\usage{
manual_correction(
  data,
  col,
  rows,
  wrong,
  correct,
  verbose = getOption("edc_correction_verbose", TRUE)
)

reset_manual_correction()
}
\arguments{
\item{data, col, rows}{the rows of a column of a dataframe where the error lies}

\item{wrong}{the actual wrong value}

\item{correct}{the temporary correction value}

\item{verbose}{whether to print informations (once)}
}
\value{
Nothing, used for side effects
}
\description{
When finding wrong or unexpected values in an exported table, it can be useful to temporarily correct them by hard-coding a value.
However, this manual correction should be undone as soon as the central database is updated with the correction.
\itemize{
\item \code{manual_correction()} applies a correction in a specific table column location and throws an error if the correction is already in place. This check applies only once per R session so you can source your script without errors.
\item \code{reset_manual_correction()} resets all checks. For instance, it is called by \code{\link[=read_trialmaster]{read_trialmaster()}}.
}
}
\examples{
library(dplyr)
x = iris \%>\% mutate(id=row_number(), .before=1) \%>\% as_tibble()
x$Sepal.Length[c(1,3,5)]

#1st correction is silent
manual_correction(x, Sepal.Length, rows=c(1,3,5),
                  wrong=c(5.1, 4.7, 5.0), correct=c(5, 4, 3))
x$Sepal.Length[c(1,3,5)]

#further correction is silent
manual_correction(x, Sepal.Length, rows=c(1,3,5),
                  wrong=c(5.1, 4.7, 5.0), correct=c(5, 4, 3)) 
                  
#if the database is corrected, an error is thrown
\dontrun{
reset_manual_correction()
x$Sepal.Length[c(1,3,5)] = c(5, 4, 3) #mimics db correction
manual_correction(x, Sepal.Length, rows=c(1,3,5),
                  wrong=c(5.1, 4.7, 5.0), correct=c(5, 4, 3))
}
}
