\name{trid}
\alias{trid}
\title{Trid function for optimization problems}

\usage{
trid(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Trid function is evaluated.
  }
}

\value{
Returns a numeric value representing the evaluation of the Trid function at the input vector \code{x}.
}

\description{
The Trid function is a benchmark function used in optimization. It is a non-convex function with a global minimum at a specific point within its domain. The function has a parabolic shape with cross terms that introduce dependencies between variables, making it a challenging test case for optimization algorithms.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- c(-1, -0.333333, 0.333333, 1)
trid(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
trid(x)

# Contour Plot: Visualizing the Trid Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) trid(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Trid Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = trid, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) trid(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Trid Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Aluffi-Pentini, F., Parisi, V., & Zirilli, F. (1985). Global optimization and stochastic differential equations. \emph{Journal of Optimization Theory and Applications}, 47(1), 1-16.}
}
