% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfdb-annotation.R
\name{wfdb_annotations}
\alias{wfdb_annotations}
\alias{read_annotation}
\alias{write_annotation}
\alias{annotate_wfdb}
\title{Read WFDB-compatible annotation file}
\usage{
read_annotation(
  record,
  record_dir = ".",
  annotator,
  wfdb_path = getOption("wfdb_path"),
  begin = "00:00:00",
  end = NA_character_,
  ...
)

write_annotation(
  data,
  annotator,
  record,
  record_dir = ".",
  wfdb_path = getOption("wfdb_path"),
  ...
)

annotate_wfdb(
  record,
  record_dir,
  annotator,
  wfdb_path = getOption("wfdb_path"),
  ...
)
}
\arguments{
\item{record}{String that will be used to name the WFDB record. Cannot
include extensions, and is not a filepath. alphanumeric characters are
acceptable, as well as hyphens (-) and underscores (_)}

\item{record_dir}{File path of directory that should be used read and write
files. Defaults to current directory.}

\item{annotator}{String that is the name of a WFDB-compatible annotation
type, serving as the extension for the file that is written containing that
annotation. Please see \code{\link[=read_annotation]{read_annotation()}} and \code{\link[=write_annotation]{write_annotation()}} for
further details.}

\item{wfdb_path}{Path that leads to installed \code{wfdb} software package on
device. Needs to be directly set using \code{set_wfdb_path()}. Obtained from the
system options on loading of the package, \code{getOption('wfdb_path')}}

\item{begin, end}{A \code{character} in the format of \emph{HH:MM:SS} that will be used
to help parse the time of the annotation. These parameters together create
the time range to extract. The default of \emph{0} is a shortcut for \emph{00:00:00}.
The \emph{seconds} argument can include a decimal place.}

\item{...}{Additional arguments to be passed to the function}

\item{data}{An \code{annotation_table} containing the 6 invariant columns required
by the \code{\link[=annotation_table]{annotation_table()}} function}
}
\value{
This function will either read in an annotation using the \code{\link[=read_annotation]{read_annotation()}} function in the format of an \code{annotation_table} object, or write to file/disk an \code{annotation_table} to a WFDB-compatible annotation file using the \code{\link[=write_annotation]{write_annotation()}} function.

\strong{IMPORTANT}: as annotation files are created by annotators that were
developed independently, there is a higher chance of an erroroneous file
being created on disk. As such, this function will note an error an return an
empty \code{annotation_table} at times.
}
\description{
Individual annotation types are described as both a command-line
tool for annotating WFDB-files, as well as the extension that is appended to
the \code{record} name to notate the type. Generally, the types of annotations
that are supported are described below:
\itemize{
\item atr = manually reviewed and corrected reference annotation files
\item ann = general annotator file
\item ecgpuwave = files contain surface ECG demarcation (P, QRS, and T waves)
\item sqrs/wqrs/gqrs = standard WFDB peak detection for R waves
}

A more thorough explanation is given in the details. Additionally, files when
being read in are converted from a binary format to a textual format. The raw
data however may be inadequate, as the original annotation may be erroneous.
In these cases, an empty \code{annotation_table} object will be returned.
}
\section{Annotation files}{
The following annotation file types are described below.
\subsection{\code{ecgpuwave}}{

\code{ecgpuwave} analyzes an ECG signal from the specified record, detecting the
QRS complexes and locating the beginning, peak, and end of the P, QRS, and
ST-T waveforms. The output of ecgpuwave is written as a standard WFDB-format
annotation file (the extension is "*.ecgpuwave", as would be expected). This
file can be converted into text format using \code{rdann}. Further details are
given at the \href{https://physionet.org/content/ecgpuwave/1.3.4/}{ECGPUWAVE}
page.

The \strong{type} column can be \emph{p}, \emph{t}, or \emph{N} for the peak of the P wave, T
wave, and QRS (R peak) directly. The output notation also includes waveform
onset XXX and waveform offset XXX. The \strong{number} column gives further
information about each of these \strong{type} labels.

The \strong{number} column gives modifier information. If the \strong{type} classifier
is a T wave annotation, the \strong{number} column can be 0 (normal), 1
(inverted), 2 (positive), 3 (negative), 4 (biphasic negative-positive), 5
(biphasic positive-negative). If the \strong{type} is an waveform onset or offset,
then \strong{number} can be 0 (P wave), 1 (QRS complex), 2 (T wave).
}
}

