% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{plotHistogramTrend}
\alias{plotHistogramTrend}
\title{plotHistogramTrend}
\usage{
plotHistogramTrend(eList, eBoot, caseSetUp, xSeq = seq(-100, 100, 10),
  flux = TRUE, printTitle = TRUE, cex.main = 1.1, col.fill = "grey",
  ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{eBoot}{named list. Returned from \code{\link{wBT}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{xSeq}{vector defaults to seq(-100,100,10). It is recommended to try the default
first. The first argument in the seq function needs to be lower than the minimum value, the second argument
needs to be higher than the highest value, both should probably be multiples of 10 or 20,
and the third argument should probably be 5 or 10.  Finally, it is good to have the first and second arguments straddle zero.}

\item{flux}{logical if TRUE, plots flux results, if FALSE plots concentration}

\item{printTitle}{logical if TRUE, includes title}

\item{cex.main}{numeric title font size}

\item{col.fill}{character fill color}

\item{\dots}{base R graphical parameters that can be passed to the hist function}
}
\description{
Histogram of trend.
}
\examples{
library(EGRET)
eList <- Choptank_eList
eBoot <- Choptank_eBoot
caseSetUp <- Choptank_caseSetUp
plotHistogramTrend(eList, eBoot, caseSetUp, flux=FALSE)

\dontrun{
caseSetUp <- trendSetUp(eList)
eBoot <- wBT(eList,caseSetUp)
plotHistogramTrend(eList, eBoot, caseSetUp,
                   flux=FALSE, xSeq = seq(-20,60,5))
plotHistogramTrend(eList, eBoot, caseSetUp,
                   flux=TRUE, xSeq = seq(-20,60,5))
}
}

