% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined.R
\name{combined_est}
\alias{combined_est}
\title{Simulataneous estimation of Michaelis-Menten constant and catalytic constant using combined data}
\usage{
combined_est(method = T, time1, time2, species1, species2, enz1, enz2, subs1,
  subs2, MM, catal, tun = 2.4, std, nrepeat, jump = 1, burning = 0,
  catal_m = 1, catal_v = 1e+05, MM_m = 1, MM_v = 1e+05)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time1}{observed time interval for data1}

\item{time2}{observed time interval for data2}

\item{species1}{observed trajectory of product for data1}

\item{species2}{observed trajectory of product for data2}

\item{enz1}{enzyme concentration for data1}

\item{enz2}{enzyme concentration for data2}

\item{subs1}{substrate concentration for data1}

\item{subs2}{substrate concentration for data2}

\item{MM}{initial value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{tun}{tunning constant of MH algorithm (default =2.4)}

\item{std}{standard deviation of proposal distribution}

\item{nrepeat}{total number of iteration}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{catal_m}{prior mean of gamma prior (default =1)}

\item{catal_v}{prior variance of gamma prior (default =10000)}

\item{MM_m}{prior mean of gamma prior (default =1)}

\item{MM_v}{prior variance of gamma prior (default =10000)}
}
\value{
A n*2 matrix of postrior samples of catalytic constant and MM constant
}
\description{
The function estimates both catalytic and MM constant simultaneously using combined
data sets for different enzyme concentrations and substrate concentrations for two
input data sets according to the different values of enzyme concentrations or
substrate concentration.
}
\details{
The function combined_est generates a set of Markov Chain Monte Carlo
simulation samples from the posterior distribution of MM and catalytic
constant of enzyme kinetics model. Because the function considers both
MM constant and catalytic constant as parameters to be estimated, the user should
input constants of enzyme concentrations, substrate concentrations.
Because this function utilizes two data sets according to the different values of
enzyme concentration or substrate concentration the user inputs two sets of information
of input data set, enzyme concentration, and substrate concentration.
prior information for both two parameter can be given.
The turning constant and standard deviation can be set to controlled proper mixing
and acceptance ratio of MM constant from it's conditional posterior distribution.
Posterior samples are only stored with fixed interval according to set "jump"
to reduce serial correlation
The initial iterations are removed for convergence. The burning is set the length of
initial iterations.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
data("Chymo_high")
time2=Chymo_high[,1]
species2=Chymo_high[,2]
enz.Chymotrypsin<-combined_est(method=TRUE, time1=time1 ,time2=time2 ,species1=species1
                               ,species2=species2,enz1=4.4e+7,enz2=4.4e+9
                               ,subs1=4.4e+7,subs2=4.4e+7,MM=1e+9,catal=0.01,
                               tun=2.0,std=8e+7,nrepeat=1000,jump=10,burning=0
                               ,catal_m=1,catal_v=1e+6, MM_m=1,MM_v=1e+10)
}
