% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimating_equations.R
\name{ee.gee}
\alias{ee.gee}
\title{Estimating equation for GEE without missingness or with data missing completely at random.}
\usage{
ee.gee(y,x,r,id,beta,rho,phi,dist,corstr)
}
\arguments{
\item{y}{A vector containing outcomes.}

\item{x}{A matrix containing covariates. The first column should be all ones the represents the intercept.}

\item{r}{A vector indicating the observation of outcomes: 1 for observed records, and 0 for unobserved records. The default setup is that all data are observed. See more in details section.}

\item{id}{A vector indicating subject id.}

\item{beta}{A plug-in estimator solved by an external estimation procedure.}

\item{rho}{A correlation coefficients obtained from an external estimation procedure, such as GEE.}

\item{phi}{An over-dispersion parameter obtained from an external estimation procedure, such as GEE.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{corstr}{A candidate correlation structure. It can be "independence","exchangeable", and "ar1".}
}
\value{
A matrix containing values of calculated estimating equations.
}
\description{
Calculate estimating equation from GEE in ELCIC without missingness or missing completely at random. This estimating equation is used for joint selection of marginal mean and working correlation structure.
}
\details{
If the element in argument "r" equals zero, the corresponding rows of "x" and "y" should be all zeros.
}
\examples{
## tests
# load data
data(geesimdata)
x<-geesimdata$x
y<-geesimdata$y
id<-geesimdata$id
corstr<-"exchangeable"
dist<-"poisson"
# obtain the estimates
library(geepack)
# x matrix already include the intercept column.
fit<-geeglm(y~x-1,data=geesimdata,family =dist,id=id,corstr = "ar1")
beta<-fit$coefficients
rho<-unlist(summary(fit)$corr[1])
phi<-unlist(summary(fit)$dispersion[1])
r<-rep(1,nrow(x))
ee.matrix<-ee.gee(y,x,r,id,beta,rho,phi,dist,corstr)
apply(ee.matrix,1,mean)

}
