% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambda.find.wgee.mean}
\alias{lambda.find.wgee.mean}
\title{Calculate the tuning parameters involved in marginal mean selection under WGEE with data missing at random}
\usage{
lambda.find.wgee.mean(y,x,r,pi,id,time,beta,rho,phi,dist,corstr)
}
\arguments{
\item{y}{A vector containing outcomes. use NA to indicate missing outcomes.}

\item{x}{A matrix containing covariates. The first column should be all ones corresponding to the intercept.}

\item{r}{A vector indicating the observation of outcomes: 1 for observed records, and 0 for unobserved records.}

\item{pi}{A vector containing observing probabilities across all observations.}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations for each subject}

\item{beta}{A plug-in estimator solved by an external estimation procedure, such as WGEE.}

\item{rho}{A correlation coefficients obtained from an external estimation procedure, such as WGEE.}

\item{phi}{An over-dispersion parameter obtained from an external estimation procedure, such as GEE.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{corstr}{A candidate correlation structure. It can be "independence","exchangeable", and "ar1".}
}
\value{
Tuning parameter values.
}
\description{
This function provides an efficient algorithm to calculate the tuning parameters involved in marginal mean selection under WGEE with data missing at random.
}
\note{
corstr should be prespecified.
}
\examples{
## tests
# load data
data(wgeesimdata)
library(wgeesel)
data_wgee<-data.frame(do.call(cbind,wgeesimdata))
corstr<-"exchangeable"
dist<-"binomial"
id<-data_wgee$id
# obtain the estimates
fit<-wgee(y~x1+x2+x3,data_wgee,id,family=dist,corstr =corstr,scale = NULL,
         mismodel =obs_ind~x_mis1)
beta<-as.vector(summary(fit)$beta)
rho<-summary(fit)$corr
phi<-summary(fit)$phi
#calculate observing probabilies for all observations
gamma<-as.vector(summary(fit$mis_fit)$coefficients[,1])
x_mis<-wgeesimdata$x_mis
pi<-cond.prob(x_mis,gamma,id,time=3)
lambda<-lambda.find.wgee.mean(y=wgeesimdata$y,x=wgeesimdata$x,r=wgeesimdata$obs_ind,
pi=pi,id=wgeesimdata$id,time=3,beta=beta,rho=rho,phi=phi,dist=dist,corstr=corstr)
lambda

}
