% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.evaluate.R
\name{env.evaluate}
\alias{env.evaluate}
\title{Calculates evaluation metrics (AUC, etc.) using latin hypercube sampling in environment space}
\usage{
env.evaluate(
  species,
  model,
  env,
  bg.source = "background",
  n.background = 10000,
  test.eval = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{species}{An enmtools.species object}

\item{model}{An enmtools.model object or a model that can be projected using the predict() function of dismo}

\item{env}{A raster or raster stack of environmental data.}

\item{bg.source}{Determines whether minima and maxima of the environment space should be picked using the environment layers or the background points.}

\item{n.background}{The number of background points to sample from the environment space.}

\item{test.eval}{When set to "true", env.evaluate evaluates the test data stored in the model object instead of the training data.}

\item{verbose}{Controls printing of various messages progress reports.  Defaults to FALSE.}

\item{...}{Arguments to be passed to othfer functions}
}
\value{
A dismo evaluate object measuring the performance of model predictions in environment space.
}
\description{
Calculates evaluation metrics (AUC, etc.) using latin hypercube sampling in environment space
}
\examples{
\donttest{
data(iberolacerta.clade)
data(euro.worldclim)
cyreni <- iberolacerta.clade$species$cyreni
cyreni.glm <- enmtools.glm(cyreni, euro.worldclim, test.prop = 0.2,
f = pres ~ bio1 + bio12, nback = 500)
env.evaluate(cyreni, cyreni.glm,  euro.worldclim)
}
}
