% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_metrics.R
\name{multilevel_exceedance_proba_error}
\alias{multilevel_exceedance_proba_error}
\title{Multilevel 'quantile_exceedance_proba_error'}
\usage{
multilevel_exceedance_proba_error(
  Probs,
  proba_levels = NULL,
  return_years = NULL,
  type_probs = c("cdf", "exceedance"),
  prefix = "",
  na.rm = FALSE,
  give_names = TRUE
)
}
\arguments{
\item{Probs}{Matrix, whose columns give, for each \code{proba_levels},
the predicted probabilities to exceed or be smaller than a fixed quantile.}

\item{proba_levels}{Vector of probability levels of the quantiles.}

\item{return_years}{The probability levels can be given in term or return years instead.
Only used if \code{proba_levels} is not given.}

\item{type_probs}{Whether the predictions are the \code{"cdf"} (default) or \code{"exceedance"} probabilities.}

\item{prefix}{A string prefix to add to the output's names (if \code{give_names} is \code{TRUE}).}

\item{na.rm}{A logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{give_names}{Whether to name the output errors (bool).}
}
\value{
A vector of length \code{length(proba_levels)} giving the \code{\link[=quantile_exceedance_proba_error]{quantile_exceedance_proba_error()}}
calibration metric of each column of \code{Probs} at the corresponding \code{proba_levels}.
If \code{give_names} is \code{TRUE}, the output vector is named \code{paste0(prefix, "exPrErr_q", proba_levels)}
(or \code{paste0(prefix, "exPrErr_", return_years,"y")} if \code{return_years} are given instead of \code{proba_levels}).
}
\description{
Multilevel version of \code{\link[=quantile_exceedance_proba_error]{quantile_exceedance_proba_error()}}.
}
