% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.plotWeight.R
\name{eco.plotWeight}
\alias{eco.plotWeight}
\title{Plot for a connection network}
\usage{
eco.plotWeight(x, type = c("simple", "igraph", "edgebundle", "network"),
  group = NULL, fontSize = 10, ebColor = NULL, vertex.size = 10,
  vertex.label = NA, bounded = FALSE, ...)
}
\arguments{
\item{x}{Connection network}

\item{type}{Plot type: "edgebundle", for a circular network, "network" for a tension network}

\item{group}{Vector with classes assigned to the individuals, in the same original order}

\item{fontSize}{Argument passed to \code{\link[networkD3]{forceNetwork}}
contained in the weight object  (which is the order of the table used to construct the weights)}

\item{ebColor}{Vector with edge colors for the groups of the edgebundler plot (Experimental feature)}

\item{vertex.size}{Parameter to \code{\link[igraph]{plot.igraph}}}

\item{vertex.label}{Parameter passed to \code{\link[igraph]{plot.igraph}}}

\item{bounded}{Logical. Value to enable (TRUE) or disable (FALSE) 
the bounding box limiting the force network graph extent see \code{\link[networkD3]{forceNetwork}}.}

\item{...}{Additional arguments passed to \code{\link[igraph]{plot.igraph}}}
}
\description{
Plot method for an eco.weight object. For examples, see  \code{\link{eco.weight}}  
This function can make a static plot with the original coordinates and an additional graph with
the coordinates transformed as ranks. It can also construct dynamic plots 
(force networks and circle networks).
}
\examples{
# see the examples in the function eco.weight:
# ?eco.weight
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
