% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/achievementLevels.R
\name{achievementLevels}
\alias{achievementLevels}
\title{Return achievement levels for an edsurvey.data.frame.}
\usage{
achievementLevels(achievementVars = NULL, aggregateBy = NULL, data,
  cutpoints = NULL, returnDiscrete = TRUE, returnCumulative = FALSE,
  weightVar = NULL, jrrIMax = 1, schoolMergeVarStudent = NULL,
  schoolMergeVarSchool = NULL, omittedLevels = TRUE,
  defaultConditions = TRUE, recode = NULL)
}
\arguments{
\item{achievementVars}{character vector indicating variables to be included in the achievement 
levels table, potentially with a subject scale or subscale. When the subject 
scale or subscale is omitted, then the default subject scale or subscale is 
used. You can find the default composite scale and all subscales using the 
function \code{\link{showPlausibleValues}}.}

\item{aggregateBy}{character vector specifying variables to aggregate achievement levels by. The percent
column sums up to 100 for all levels of all variables specified here. When set to 
default of \code{NULL}, the percent column sums up to 100 for all levels of all variables specified in 
in \code{achievementVars}.}

\item{data}{an edsurvey.data.frame.}

\item{cutpoints}{numeric vector indicating cut points. Set to standard NAEP cut points for 
Basic, Proficient, Advanced by default.}

\item{returnDiscrete}{logical indicating if discrete achievement levels should be returned. Defaults 
to \code{TRUE}.}

\item{returnCumulative}{logical indicating if cumulative achievement levels should be returned. Defaults
to \code{FALSE}.}

\item{weightVar}{character indicating the weight variable to use; see Details.}

\item{jrrIMax}{numeric value. When using jackknife variance estimation method, the \eqn{V_{jrr}} term
(see Details) can be estimated with any positive number of plausible values and is 
estimated on the first of the lower of the number of available plausible values and 
\code{jrrIMax}. When \code{jrrIMax} is set to Inf, all of the plausible values will 
be used. Higher values of \code{jrrIMax} lead to longer computing times and more
accurate variance estimates.}

\item{schoolMergeVarStudent}{a character variable name from the student file used to merge student 
and school data files. Set to \code{NULL} by default.}

\item{schoolMergeVarSchool}{a character variable name from the school file used to merge student 
and school data files. Set to \code{NULL} by default.}

\item{omittedLevels}{a logical value. When set to the default value of \code{TRUE}, drops those levels of 
all factor variables that are specified in \code{achievementVars} and \code{aggregateBy}. 
Use \code{print} on an \code{edsurvey.data.frame} to see the omitted levels.}

\item{defaultConditions}{a logical value. When set to the default value of \code{TRUE}, uses the default 
conditions stored in \code{edsurvey.data.frame} to subset the data. 
Use \code{print} on an \code{edsurvey.data.frame} to see the default
conditions.}

\item{recode}{a list of lists to recode variables. Defaults to \code{NULL}. Can be set as
recode = list(var1= list(from=c("a,"b","c"), to ="d")). See Examples.}
}
\value{
A \code{list} containing up to two \code{data.frame} (s), one for each of the discrete and cumulative achievement levels
as determined by \code{returnDiscrete} and \code{returnCumulative}. The \code{data.frame} contains the following columns:
\item{\code{Level}}{One row for each level of the specified achievement cut points.}
\item{Variables in achievementVars}{One column for each variable in \code{achievementVars}, and one row for each level of each variable in \code{achievementVars}.}
\item{\code{Percent}}{Percentage of students at or above each achievement level aggregated as specified by \code{aggregateBy}.}
\item{\code{StandardError}}{The standard error of the percentage, accounting for the survey sampling methodology. See the statistics vignette.}
\item{\code{n0}}{The number of observations in the incomding data (the
                 number of rows when \code{omittedLevels} and
                 \code{defaultConditions} are set to \code{FALSE}.}
\item{\code{nUsed}}{The number of observations in the data after applying all
                    filters (see \code{omittedLevels} and
                    \code{defaultConditions}).}
}
\description{
Returns achievement levels using weights and variance estimates appropriate for the \code{edsurvey.data.frame}.
}
\details{
The \code{achievementLevels} function applies appropriate weights and variance estimation method for each
         \code{edsurvey.data.frame}, with several arguments for customizing the aggregation and output of the analysis 
         results. Namely, by using these optional arguments, users can choose to generate the percentage of students 
         performing at each achievement level (discrete), at or above each achievement level (cumulative), 
         calculating the percentage distribution of students by achievement levels (discrete or cumulative) and 
         selected characteristics (specified in \code{aggregateBy}), and computing the percentage distribution of students 
         by selected characteristics within a specific achievement level.

\subsection{Calculation of percentages}{
         The details of the methods are shown in the statistics vignette, which you can read by 
         running \code{vignette("statistics", package="EdSurvey")} at the R prompt. The methods described in
         \dQuote{Estimation of weighted percentages when plausible values are present} are use to calculate 
         all cumulative and discrete probabilities.

         When the requested achievement levels are discrete (\code{returnDiscrete = TRUE}),
         the percentage \eqn{\mathcal{A}} is the percentage of students (within the categories specified in \code{aggregateBy}) 
         whose scores lie in the range  [\eqn{cutPoints_i}, \eqn{cutPoints_{i+1}}), i = 0,1,...,n.
         \code{cutPoints} is the score thresholds provided by the user with \eqn{cutPoints_0} taken
         to be 0. \code{cutPoints} are set to NAEP standard cut points for achievement levels by default.
         To aggregate by a specific variable, for example, \code{dsex}, specify \code{dsex} in \code{aggregateBy}
         and all other variables in \code{achievementVars}. To aggregate by achievement levels, specify 
         the name of the plausible value in \code{aggergateBy} and all other variables in 
         \code{achievementVars} 
         

         When the requested achievement levels are cumulative (\code{returnCumulative = TRUE})
         the percentage \eqn{\mathcal{A}} is the percentage of students (within the categories specified in \dQuote{aggregateBy}) 
         whose scores lie in the range  [\eqn{cutPoints_i}, \eqn{\infty}), i = 1,2...,n-1. The 
         first and last categories are the same as defined for discrete levels.
} 
        
\subsection{Calculation of standard error of percentages}{
         The method used to calculate the standard error of the percentages is described in the \emph{Statistics} vignette
         in the section
\dQuote{Estimation of the standard error of weighted percentages when plausible values are present, using the jackknife method.}
        the value of \code{jrrIMax} sets the value of \eqn{m^*}.
}
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# Discrete achievement Levels
achievementLevels(achievementVars=c("composite"), aggregateBy=NULL, data=sdf) 

# Cumulative achievement Levels
achievementLevels(achievementVars=c("composite"), aggregateBy=NULL, data=sdf, 
                  returnCumulative=TRUE) 

# Achievement levels as independent variables, by sex aggregated by composite
achievementLevels(achievementVars=c("composite", "dsex"), aggregateBy="composite",
                  data=sdf, returnCumulative = TRUE) 

# Achievement levels as independent variables, by sex aggregated by sex
achievementLevels(achievementVars=c("composite", "dsex"), aggregateBy="dsex", 
                  data=sdf, returnCumulative=TRUE) 

# Achievement levels as independent variables, by race aggregated by race
achievementLevels(achievementVars=c("composite", "sdracem"),
                  aggregateBy="sdracem", data=sdf, returnCumulative=TRUE) 

# Use recode to change values for specified variables:
achievementLevels(achievementVars=c("composite","dsex", "b017451"),
                           aggregateBy = "dsex", sdf,
                           recode=list(
                             b017451=list(
                               from=c("Never or hardly ever",
                                      "Once every few weeks","About once a week"),
                               to=c("Infrequently")),
                             b017451=list(
                               from=c("2 or 3 times a week","Every day"),
                               to=c("Frequently"))))

}
}
\references{
Rubin, D. B. (1987). \emph{Multiple Imputation for Nonresponse in Surveys}. New York, NY: Wiley.
}
\author{
Ahmad Emad
}
